/**
 * 
 */
package gov.va.med.mhv.integration.phr.service.pathways;

import gov.va.med.mhv.integration.phr.stage.transfer.StageEntity;

import java.util.List;

/**
 * @author DNS
 * 
 * Interface use by query service classes to transform data in preparation for 
 * storage to the eVault.
 *
 */
public interface Transformer<T, S extends StageEntity> {
	
	/**
	 * Transform incoming data to stage type. 
	 * @param transformFrom The data being transformed from.
	 * @return The transformed results.
	 * @throws TransformationException In case of errors, <code>TransformationException</code> is thrown.
	 */
	List<S> transform(T transformFrom) throws TransformationException;
}
